---
title: FunASR API Usage Guide
slug: gKriAn53WLFxGYd6BwWvy
createdAt: Thu Jul 18 2024 06:17:27 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 06:42:25 GMT+0000 (Coordinated Universal Time)
---

# FunASR API Usage Guide

## Introduction

This document will guide developers on how to use the `aonet` library to invoke the FunASR API, which is used for Automatic Speech Recognition (ASR).

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Installation

Ensure the `aonet` library is installed. If not, you can install it using npm:

```bash
npm install aonet
```

## Usage Instructions

### 1. Import the `aonet` Library

```javascript
const AI = require("aonet");
```

### 2. Configure Options

Create an `options` object containing your APPID:

```javascript
const options = {
    appid: "your_APPID"
};
```

Make sure to replace `"your_APPID"` with your actual Aonet APPID.

### 3. Initialize AI Instance

Initialize the AI instance using the configuration options:

```javascript
const aonet = new AI(options);
```

### 4. Invoke FunASR API

Use the `prediction` method to call the FunASR API:

```javascript
async function performSpeechRecognition() {
    try {
        let response = await aonet.prediction("/predictions/ai/funasr", {
            input: {
                "awv": "https://aonet.ai/mgxm/d9fa255c-4c47-4fec-99ce-f190539f10c4/olle.mp3",
                "batch_size": 300
            }
        });
        console.log("FunASR result:", response);
    } catch (error) {
        console.error("Error performing speech recognition:", error);
    }
}

performSpeechRecognition();
```

### Parameter Description

- `awv`: String, specifies the URL of the audio file to be recognized.
- `batch_size`: Integer, specifies the batch size for processing the audio. This may affect processing speed and memory usage.

## Considerations

- Ensure the provided audio URL is publicly accessible and of good quality for optimal recognition results.
- The API may take some time to process the audio and generate results, especially for longer audio files. Consider implementing appropriate waiting or loading states.
- Handle potential errors, such as network issues, invalid input, or API limitations.
- Adhere to terms of use and privacy regulations, especially when processing audio containing sensitive information.

## Example Response

The API response will contain the recognized text content. Parse and use the response data according to the actual API documentation.

## Advanced Usage

- Implement batch audio processing by processing multiple audio files in a loop or concurrently.
- Add a user interface to allow users to upload their audio files or provide audio URLs.
- Implement real-time speech recognition by integrating the API into live audio streams.
- Integrate post-processing features for text, such as punctuation addition, semantic analysis, or sentiment analysis.
- Consider implementing multi-language support to handle audio in different languages as needed.

By following this guide, you should be able to effectively use the FunASR API for automatic speech recognition in your applications. If you have any questions or need further clarification, feel free to ask.

